<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<!DOCTYPE html>
<html>
<head>
<title><spring:message code="label.title.front"/></title>
<meta charset="utf-8" />
<meta http-equiv="pragma" content="no-cache"/>
<meta http-equiv="cache-control" content="no-cache"/>
<meta http-equiv="expires" content="0"/>
<link rel="stylesheet" type="text/css" href="<%=request.getContextPath()%>/resources/mta/css/common.css" />
<script src="<%=request.getContextPath()%>/resources/js/jquery-easyui-1.4/jquery.min.js" type="text/javascript"></script>
<script src="<%= request.getContextPath()%>/resources/js/jquery-easyui-1.4/jquery.easyui.min.js" type="text/javascript"></script>
<script src="<%= request.getContextPath()%>/resources/js/ajax-pushlet-client.js" type="text/javascript"></script>
<script type="text/javascript">
	var baseUrl='<%= request.getContextPath()%>';
	var loginUserId=${user.userid};
</script>
	<script src="<%= request.getContextPath()%>/resources/js/mta/header.js" type="text/javascript"></script>
</head>

<body>
<div class="bar">
	<div class="w">
		<div class="bar_left l">
			<spring:message code="label.welcome.title"/> ${sessionScope.user.realname==''? sessionScope.user.username : sessionScope.user.realname}
		</div>
		<ul class="bar_right r">
			<c:if test="${sessionScope.user==null && isRegistFlg}">
			<li class="l register">
				<!-- 注册 -->
				<a href="<%= request.getContextPath()%>/mta/runToRegist.html"><spring:message code="label.font.register"/></a>
			</li>
			</c:if>
			<c:if test="${sessionScope.user==null}">
			<li class="l">
				<!-- 登录 -->
				<a href="<%= request.getContextPath()%>/mta/login.html"><spring:message code="label.font.login"/></a>
			</li>
			</c:if>
			<c:if test="${sessionScope.user!=null}">
			<li class="l">
				<!-- 个人中心 -->
				<a href="<%= request.getContextPath()%>/mta/P010/myCenter.html"><spring:message code="label.font.center"/></a>
			</li>
			<li class="l quit">
				<!-- 退出 -->
				<a  href="javascript:void(0);" onclick="javascript:logout();"><spring:message code="label.font.quit"/></a>
			</li>
			</c:if>
		</ul>
	</div>
</div>
<div class="nav w">
	<div class="logo l">
		<img src="<%= request.getContextPath()%>/resources/logo/logo.png"/>
	</div>
	<ul class=" r nav_list">
		<li class="l">
			<!-- 首页 -->
			<a href="<%= request.getContextPath()%>/index.html"><spring:message code="label.font.index"/></a>
		</li>
<!-- 		<li class="l"> -->
<!-- 			<!-- 直播课程 -->
<%-- 			<a href="<%= request.getContextPath()%>/mta/F010/IM.html?uuid=f08cc934-1ee6-418b-a658-daa92e9548c9"><spring:message code="label.font.LiveCourse"/></a> --%>
<!-- 		</li> -->
		<li class="l">
			<!-- 课程学习 -->
			<a href="<%= request.getContextPath()%>/mta/F010/Course.html"><spring:message code="label.font.course"/></a>
		</li>
		<li class="l">
			<!-- 在线测试 -->
			<a href="<%= request.getContextPath()%>/mta/F020/Exam.html"><spring:message code="label.font.exam"/></a>
		</li>
		<li class="l">
			<!-- 共享资源 -->
			<a href="<%= request.getContextPath()%>/mta/F030/Resources.html"><spring:message code="label.font.resources"/></a>
		</li>
		<li class="l">
			<!-- 共享资源 -->
			<a href="<%= request.getContextPath()%>/mta/F040/showAsk.html"><spring:message code="label.font.showAsk"/></a>
		</li>
	</ul>
</div>
</body>
</html>